﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage

    Public Sub New()
        InitializeComponent()

        FillItUp(itemsControl)
        FillItUp(listBox)
    End Sub


    Private Sub FillItUp(ByVal itemsControl As ItemsControl)
        Dim fontFamilies() =
            {"Arial", "Arial Black", "Calibri", "Comic Sans MS",
            "Courier New", "Georgia", "Lucida Sans Unicode",
            "Portable User Interface", "Segoe WP", "Segoe WP Black",
            "Segoe WP Bold", "Segoe WP Light", "Segoe WP Semibold",
            "Segoe WP SemiLight", "Tahoma", "Times New Roman",
            "Trebuchet MS", "Verdana", "Webdings"}

        For Each _fontFamily In fontFamilies
            itemsControl.Items.Add(New FontFamily(_fontFamily))
        Next _fontFamily
    End Sub


    Private Sub OnItemsControlDumpClick(ByVal sender As Object,
                                        ByVal args As RoutedEventArgs)
        dumpTreeItemsControl.Items.Clear()
        DumpVisualTree(itemsControl, 0)
    End Sub


    Private Sub OnListBoxDumpClick(ByVal sender As Object,
                                   ByVal args As RoutedEventArgs)
        dumpTreeItemsControl.Items.Clear()
        DumpVisualTree(listBox, 0)
    End Sub


    Private Sub DumpVisualTree(ByVal parent As DependencyObject,
                               ByVal indent As Integer)
        Dim txtblk As New TextBlock()
        txtblk.Text = String.Format("{0}{1}",
                                    New String(" "c, 4 * indent),
                                    parent.GetType().Name)
        dumpTreeItemsControl.Items.Add(txtblk)

        Dim numChildren = VisualTreeHelper.GetChildrenCount(parent)

        For childIndex = 0 To numChildren - 1
            Dim child = VisualTreeHelper.GetChild(parent, childIndex)
            DumpVisualTree(child, indent + 1)
        Next childIndex
    End Sub
End Class
